unit UnitGeneric;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, UnitDadesGlobus2, MMSystem, StdCtrls, UnitMatematiques;

type
  TFormFrequencia = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    Panel1: TPanel;
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
    ValorMaximDelSo:integer;
    UnitatEixX:LongInt;
    UnitatEixY:LongInt;
    procedure Pintar;
  end;

var
  FormFrequencia: TFormFrequencia;

{************************************************}
IMPLEMENTATION
{************************************************}

Uses UnitTools, UnitEntradaDeSo, UnitDades, UnitCalculsLPC, UnitCalculsMatematics;

{$R *.DFM}

var
  Numeros:array[0..100] of NumerosPerCalcular;

procedure TFormFrequencia.FormPaint(Sender: TObject);
begin
  Pintar;
end;

procedure TFormFrequencia.FormResize(Sender: TObject);
begin
  Repaint;
end;

procedure TFormFrequencia.SpeedButtonEngegarPararClick(Sender: TObject);
begin
   if SpeedButtonEngegarParar.Down then begin
    IniciarDadesEntradaDeSo;
    //128-256-512-1024-2048
    //GrandariaBytesBufferEntradaDeSo:=512;
    GrandariaBytesBufferEntradaDeSo:=512;
    //8-16
    BitsPerMostraEntradaSo:=16;
    //11025-22050-44100
    FrequenciaDeMostreigEntradaSo:=11025;
    if EngegarProcesEntradaDeSo(Handle)=0 then SpeedButtonEngegarParar.Caption:='P';
  end else begin
    PararEntradaDeSo;
    SpeedButtonEngegarParar.Caption:='E';
    FinalitzarEntradaDeSo;
  end;
end;

procedure TFormFrequencia.WMWIMDATA(var Msg: TMessage);
var
  i:integer;
begin
  if ParoProcesContinuEntradaDeSo then exit;
  ValorMaximDelSo:=ValorMaximDetectatEntradaDeSo;
  for i:=1 to GrandariaNumerosBufferEntradaDeSo do Numeros[0,i]:=NumerosEntradaDeSo[i];
  if ValorMaximDelSo>0 then begin
    Repaint;
  end else begin
  end;
end;

procedure TFormFrequencia.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=ClientRect.Bottom;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

procedure TFormFrequencia.Pintar;
begin
end;

end.
